/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY                          *
 *                                                                            *
 * This program is free software; you can redistribute it and/or modify       *
 * it under the terms of the GNU General Public Liense as published by        *
 * the Free Software Foundation, either version 2 of the License, or (at      * 
 * your option) any later version.                                            *
 *                                                                            *
 * The ITX package is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY, without even the implied warranty of MERCHANTABILITY *
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License   *
 * for more details.                                                          * 
 *                                                                            *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.                                                   *
 *                                                                            * 
 * Contact information:                                                       *
 * Donna Bergmark                                                             *
 * 484 Rhodes Hall                                                            *
 * Cornell University                                                         *
 * Ithaca, NY 14853-3801                                                      *
 * bergmark@cs.cornell.edu                                                    *
 ******************************************************************************/
package shared;

import java.io.*;

/**
 * This class contains all global SPOT definitions.
 */
public class SPOTDefinitions
{
	/**
	 * PowerPoint presentation file suffix.
	 */
	public final static String PRESENTATION_FILE_SUFFIX	= new String(".ppt");
	
	/**
	 * SPT file suffix.
	 */
	public final static String SPT_FILE_SUFFIX			= new String(".spt");
	
	/**
	 * PAM file suffix.
	 */
	public final static String PAM_FILE_SUFFIX			= new String(".pam");
	
	/**
	 * RAD file suffix.
	 */
	public final static String RAD_FILE_SUFFIX			= new String(".rad");
	
	/**
	 * Audio sample buffer size (in bytes).
	 */
	//public final static int AUDIO_BUFFER_SIZE			= 200;
	
	/**
	 * Audio buffer time (for flow control) in ms
	 */	
	public final static int AUDIO_BUFFER_TIME			= 200;
	
	/**
	 * Audio sample rate (in samples/sec).
	 */
	public final static int AUDIO_SAMPLE_RATE			= 8000;
	
	/**
	 * Audio sample size (in bits).
	 */
	public final static int AUDIO_SAMPLE_SIZE			= 8;
	
	/**
	 * ITX SPOT service strings
	 */
	public static final String SPOT_SERVICE				= "spot";
	public static final String SPOT_CLIENT				= "spot-client";
	public static final String SPOT_SERVER				= "spot-server";
		
	/**
	 * SPOT registry settings
	 */
	public static final String SPOT_REGISTRY_KEY		= "SPOT";
	public static final String SPOT_REGISTRY_DIRECTORY	= "SPOTDirectory";
	public static final String SPOT_REGISTRY_DS			= "SPOTDirectoryService";
	
	/**
	 * Default SPOT server port
	 */
	public static final int SERVER_PORT					= 7777;
	
	/**
	 * File chunk size
	 */
	public static final int FILE_CHUNK_SIZE				= 200;
	
	/**
	 * Default presentation name
	 */
	public static final String DEFAULT_PRESENTATION_NAME= new String("");
	
	/**
	 * Determines whether a given filename is the name of a PAM file.
	 */
	public static boolean isSPTFile(String filename)
	{
		int lastDot;
		String suffix;
		
		// Get the file suffix
		if ((lastDot = filename.lastIndexOf(".")) == -1)
		{
			return false;
		}
		
		suffix = filename.substring(lastDot, filename.length());
		
		// Filter test
		if (suffix.equals(SPOTDefinitions.SPT_FILE_SUFFIX))
		{
			return true;
		}
		
		return false;
	}
	
	/**
	 * Determines whether a given filename is the name of a SPT file.
	 */
	public static boolean isPAMFile(String filename)
	{
		int lastDot;
		String suffix;
		
		// Get the file suffix
		if ((lastDot = filename.lastIndexOf(".")) == -1)
		{
			return false;
		}
		
		suffix = filename.substring(lastDot, filename.length());
		
		// Filter test
		if (suffix.equals(SPOTDefinitions.PAM_FILE_SUFFIX))
		{
			return true;
		}
		
		return false;		
	}
	
	/**
	 * Determines whether a given filename is the name of a PPT file.
	 */
	public static boolean isPPTFile(String filename)
	{
		int lastDot;
		String suffix;
		
		// Get the file suffix
		if ((lastDot = filename.lastIndexOf(".")) == -1)
		{
			return false;
		}
		
		suffix = filename.substring(lastDot, filename.length());
		
		// Filter test
		if (suffix.equals(SPOTDefinitions.PRESENTATION_FILE_SUFFIX))
		{
			return true;
		}
		
		return false;		
	}	
}
